package com.agilex.healthcare.veteranappointment.uri;

import java.net.URI;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.UriBuilder;

import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

import com.agilex.healthcare.mobilehealthplatform.domain.AtomLink;
import com.agilex.healthcare.mobilehealthplatform.domain.ResourceDirectory;
import com.agilex.healthcare.mobilehealthplatform.domain.atom.rel;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.veteranappointment.domain.VARLinkTitles;

@Service
@Scope(value=ConfigurableBeanFactory.SCOPE_PROTOTYPE)
public class VARPatientResourceDirectoryBuilder {
	public VARPatientResourceDirectoryBuilder(){
	}
	
	public ResourceDirectory getResourceDirectory(URI systemBaseUri,String patientId,String assigningAuthority){
		if(NullChecker.isNullish(patientId)|| NullChecker.isNullish(assigningAuthority)){
			throw new WebApplicationException(Status.BAD_REQUEST);
		}
		ResourceDirectory resourceDirectory = new ResourceDirectory();
		
		AtomLink link;
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("appointment-service").path("var-patient-resource-directory").queryParam("patientId", patientId).queryParam("assigningAuthority", assigningAuthority).build());
		link.setTitle("var-patient-resource-directory");
		resourceDirectory.getLink().setSelfLink(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("appointment-service").path("patient").path(assigningAuthority).path(patientId).path("appointments").build());
		link.setTitle("var-appointments");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("appointment-service").path("metadata").build());
		link.setTitle("var-metadata");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("patient").path(assigningAuthority).path(patientId).path("preference").build());
		link.setTitle("var-notification-preference");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("appointment-service").path("feedback").build());
		link.setTitle("var-feedback");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling").path("directscheduling-resource-directory").build());
		link.setTitle("directscheduling-resource-directory");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling").path("patient").path(assigningAuthority).path(patientId).path("facility-provider").build());
		link.setTitle("facility-provider");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling").path("patient").path(assigningAuthority).path(patientId).path("facility-provider-view").build());
		link.setTitle("facility-provider-view");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
		link.setHref(UriBuilder.fromPath(systemBaseUri.getPath()).path("direct-scheduling").path("patient").path(assigningAuthority).path(patientId).path("facility-provider-all").build());
		link.setTitle("facility-provider-all");
		resourceDirectory.getLink().add(link);
		
		link = new AtomLink();
        URI primaryCareProviders = UriBuilder.fromPath(systemBaseUri.getPath()).path("provider-service").path("patient").path(assigningAuthority)
                .path(patientId).path("providers").path("primarycare").build();
        link.setHref(primaryCareProviders);
        link.setTitle("primary-care-providers");
        resourceDirectory.getLink().add(link);
        
        link = new AtomLink();
        URI mentalHealthProviders = UriBuilder.fromPath(systemBaseUri.getPath()).path("provider-service").path("patient").path(assigningAuthority)
                .path(patientId).path("providers").path("mentalhealth").build();
        link.setHref(mentalHealthProviders);
        link.setTitle("mental-health-providers");
        resourceDirectory.getLink().add(link);
        
        link = new AtomLink();
        URI facilities = UriBuilder.fromPath(systemBaseUri.getPath()).path("facility-service").path("facilities").build();
        link.setHref(facilities);
        link.setTitle("var-facilities");
        resourceDirectory.getLink().add(link);
        
        return resourceDirectory;
	}
}
